$assemblyFile = Get-Location
$assemblyFile = $assemblyFile.Path + '\inetsoftware.Reporting.dll';
$assembly = [System.Reflection.Assembly]::LoadFrom($assemblyFile);


try
{
	$engine = New-Object inetsoftware.Reporting.Engine('pdf');
	$engine.ReportFile = $PSScriptRoot + '\..\resources\Sample.rpt';
	$engine.Execute();

    $exportFile = Get-Location
    $exportFile = $exportFile.Path + '\Sample.pdf';
	$stream = New-Object System.IO.FileStream $exportFile, 'Create'
	for ($i=1; $i -le $engine.PageCount; $i++) {
	    $page = $engine.PageData($i);
		$stream.Write($page, 0, $page.Length);
	}
	$stream.Close();
}
catch
{
	$PSItem.Exception.ToString()
}

Write-Host -NoNewLine 'Press any key to continue...';
$null = $Host.UI.RawUI.ReadKey('NoEcho,IncludeKeyDown');